<?php
/**
 * Magiccart 
 * @category    Magiccart 
 * @copyright   Copyright (c) 2014 Magiccart (http://www.magiccart.net/) 
 * @license     http://www.magiccart.net/license-agreement.html
 * @Author: DOng NGuyen<nguyen@dvn.com>
 * @@Create Date: 2016-01-05 10:40:51
 * @@Modify Date: 2019-08-12 00:44:26
 * @@Function:
 */

namespace Magiccart\Magicproduct\Block\Category;

use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Catalog\Model\Category;
use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Entity\Collection\AbstractCollection;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Catalog\Block\Product\AbstractProduct;

class GridProduct extends \Magiccart\Magicproduct\Block\Product\ListProduct
{

    protected $_limit; // Limit Product
    protected $_types; // types is types filter bestseller, featured ...

    /**
     * Product collection factory
     *
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    protected $_productCollectionFactory;

    /**
     * Catalog product visibility
     *
     * @var \Magento\Catalog\Model\Product\Visibility
     */
    protected $_catalogProductVisibility;

    /**
     * Product collection factory
     *
     * @var \Magento\CatalogWidget\Model\RuleFactory
     */
    protected $_ruleFactory;

    protected $sqlBuilder;

    protected $_parameters; // Condition Product

    public function __construct(
        \Magento\Catalog\Block\Product\Context $context,
        \Magento\Framework\Data\Helper\PostHelper $postDataHelper,
        \Magento\Catalog\Model\Layer\Resolver $layerResolver,
        CategoryRepositoryInterface $categoryRepository,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\Product\Visibility $catalogProductVisibility,
        \Magento\Framework\Url\Helper\Data $urlHelper,
        \Magento\CatalogWidget\Model\RuleFactory $ruleFactory,
        \Magento\Rule\Model\Condition\Sql\Builder $sqlBuilder,
        \Magiccart\Magicproduct\Model\Magicproduct $magicproduct,
        array $data = []
    ) {
        $this->_productCollectionFactory = $productCollectionFactory;
        $this->_catalogProductVisibility = $catalogProductVisibility;
        $this->_ruleFactory = $ruleFactory;
        $this->sqlBuilder   = $sqlBuilder;
        $this->_magicproduct = $magicproduct;
        parent::__construct(  
            $context, 
            $postDataHelper, 
            $layerResolver, 
            $categoryRepository, 
            $urlHelper, 
            $data
        );
    }

    public function getTypeFilter() // getTypeFilter
    {
        $type = $this->escapeHtml($this->getRequest()->getParam('type'));
        if(!$type) $type = $this->getActivated(); // get form setData in Block
        return $type;
    }

    public function getWidgetCfg($cfg=null)
    {
        $info = $this->getRequest()->getPost('info');
        if($info){
            if(isset($info['identifier'])){
                $identifier = $info['identifier']; 
                $item = $this->_magicproduct->getCollection()->addFieldToSelect('config')
                                ->addFieldToFilter('identifier', $identifier)->addFieldToFilter('type_id', 2)->getFirstItem();
                $config = $item->getConfig();
                $data = @unserialize($config);
                $this->_parameters =  isset($data['parameters']) ? $data['parameters'] : '';
            }
            if(isset($info[$cfg])) return $info[$cfg];
            return $info;          
        }else {
            $info = $this->getCfg();
            $this->_parameters =  $this->getCfg('parameters');
            if(isset($info[$cfg])) return $info[$cfg];
            return $info;
        }
    }

    public function getPositioned()
    {
        $positioned = parent::getPositioned();
        if(parent::getPositioned() == NULL){
            return '';
        }else{
            return $positioned;
        }

    }

    protected function _getProductCollection()
    {

        if (is_null($this->_productCollection)) {
            $collection = $this->_productCollectionFactory->create();
            $collection->setVisibility($this->_catalogProductVisibility->getVisibleInCatalogIds());
            if($this->getTypeFilter()){
                $category = $this->categoryRepository->get($this->getTypeFilter());
                $collection->addAttributeToSelect('*');
                $this->_productCollection = $collection->addCategoryFilter($category);
            }else{
                $this->_productCollection = $collection->addAttributeToSelect('*');
            }
        }

        $this->_limit = (int) $this->getWidgetCfg('limit');
        $this->_types = $this->escapeHtml($this->getWidgetCfg('types'));
        if(!$this->_types || is_array($this->_types)){
            $ids = [$this->getTypeFilter()];
        
            $collection = $this->_productCollectionFactory->create();
            $collection->setVisibility($this->_catalogProductVisibility->getVisibleInCatalogIds());
            $collection->addAttributeToSelect('*');
            if($this->getTypeFilter() != 0){
                $collection->addCategoriesFilter(['in' => $ids]);
            }
            return $collection->setPageSize($this->_limit);
        }
    
        $fn = 'get' . ucfirst( $this->_types );
        $collection = $this->{$fn}($this->_productCollection);

        $parameters = $this->_parameters;
        if($parameters){
            $rule = $this->getRule($parameters);
            $conditions = $rule->getConditions();
            $conditions->collectValidatedAttributes($collection);
            $this->sqlBuilder->attachConditionToCollection($collection, $conditions);
        }

        return $collection->setPageSize($this->_limit);

    }

    protected function getRule($conditions)
    {
        $rule = $this->_ruleFactory->create();
        if(is_array($conditions)) $rule->loadPost($conditions);
        return $rule; 
    }

    public function getBestseller($collection){

        $producIds = [];
        foreach ($collection as $product) {
            $producIds[] = $product->getId();
        }

        $collection = $this->_productCollectionFactory->create();
        $collection->joinField(
                'qty_ordered', 'sales_bestsellers_aggregated_yearly', 'qty_ordered', 'product_id=entity_id', null, 'inner'
            );

        $categoryId = $this->getTypeFilter();
        if($categoryId){ /* All categoryId = 0 not filter */
            $collection->addCategoriesFilter(['in' => [$categoryId]]);
        }

        $collection->addAttributeToFilter('entity_id', ['in' => $producIds])
                ->groupByAttribute('entity_id')
                ->addAttributeToSort('qty_ordered', 'desc')
                ->addStoreFilter()
                ->setPageSize($this->_limit)->setCurPage(1);            

        $collection = $this->_addProductAttributesAndPrices(
            $collection
        );
    
        return $collection;
        
    }

    public function getFeatured($collection)
    {

        $collection->addAttributeToFilter('featured', '1');

        return $collection;

    }

    public function getLatest($collection){

        $collection = $collection->addStoreFilter()
        ->addAttributeToSort('entity_id', 'desc');

        return $collection;

    }

    public function getNew($collection) {

        $todayStartOfDayDate = $this->_localeDate->date()->setTime(0, 0, 0)->format('Y-m-d H:i:s');
        $todayEndOfDayDate = $this->_localeDate->date()->setTime(23, 59, 59)->format('Y-m-d H:i:s');

        $collection = $collection->addStoreFilter()->addAttributeToFilter(
            'news_from_date',
            [
                'or' => [
                    0 => ['date' => true, 'to' => $todayEndOfDayDate],
                    1 => ['is' => new \Zend_Db_Expr('null')],
                ]
            ],
            'left'
        )->addAttributeToFilter(
            'news_to_date',
            [
                'or' => [
                    0 => ['date' => true, 'from' => $todayStartOfDayDate],
                    1 => ['is' => new \Zend_Db_Expr('null')],
                ]
            ],
            'left'
        )->addAttributeToFilter(
            [
                ['attribute' => 'news_from_date', 'is' => new \Zend_Db_Expr('not null')],
                ['attribute' => 'news_to_date', 'is' => new \Zend_Db_Expr('not null')],
            ]
        )->addAttributeToSort('news_from_date', 'desc');

        return $collection;
    }

    public function getRandom($collection) {

        $producIds = [];
        foreach ($collection as $product) {
            $producIds[] = $product->getId();
        }
        $collection = $this->_productCollectionFactory->create();
        $collection = $collection->addAttributeToSelect('*')
                    ->addAttributeToFilter('entity_id', ['in' => $producIds]);
        $collection->getSelect()->order('rand()');

        return $collection;
    }

    public function getRecently($collection) {

        $ids = $collection->getAllIds();
        $collection = $this->getLayout()->createBlock('Magento\Reports\Block\Product\Viewed');
        if(!$collection){
            $collection = $collection
                        ->setProductIds($ids)
                        ->setPageSize($this->_limit)
                        ->getItemsCollection();
        } else {
            $report = $this->_objectManager->create('\Magento\Reports\Model\Product\Index\Viewed');
            $report = $collection->getCollection()
                                    ->addAttributeToSelect('*')
                                    ->addFieldToFilter('product_id', array('in' => $ids))
                                    ->setPageSize($this->_limit)
                                    ->setCurPage(1);          
        }

        return $collection;
    }

    public function getSale($collection){

        $todayStartOfDayDate = $this->_localeDate->date()->setTime(0, 0, 0)->format('Y-m-d H:i:s');
        $todayEndOfDayDate = $this->_localeDate->date()->setTime(23, 59, 59)->format('Y-m-d H:i:s');
        $collection = $collection->addStoreFilter()->addAttributeToFilter(
            'special_from_date',
            [
                'or' => [
                    0 => ['date' => true, 'to' => $todayEndOfDayDate],
                    1 => ['is' => new \Zend_Db_Expr('null')],
                ]
            ],
            'left'
        )->addAttributeToFilter(
            'special_to_date',
            [
                'or' => [
                    0 => ['date' => true, 'from' => $todayStartOfDayDate],
                    1 => ['is' => new \Zend_Db_Expr('null')],
                ]
            ],
            'left'
        )->addAttributeToFilter(
            [
                ['attribute' => 'special_from_date', 'is' => new \Zend_Db_Expr('not null')],
                ['attribute' => 'special_to_date', 'is' => new \Zend_Db_Expr('not null')],
            ]
        )->addAttributeToSort('special_to_date', 'desc');

        return $collection;

    }

    
    /**
     *
     * @param \Magento\Catalog\Model\Product $product
     * @return int|null
     */
    public function getProductQty($product)
    {
        $stockItem = $this->stockRegistry->getStockItem($product->getId(), $product->getStore()->getWebsiteId());
        $qty = $stockItem->getQty();
        return $qty > 0 ? $qty : 0;
    }

    public function getCategory($categoryId)
    {
        return $this->categoryRepository->get($categoryId);
    }

}
