[<img src="https://github.com/magepow/themeforest/blob/master/shopify/shopify_affiliate.jpg" >](https://shopify.pxf.io/VyL446)

## Magento 2 Speed Optimizer Extension

The speed of your website is slow, which has a negative effect on Google rating and ranking and especially on the customer experience. Magento 2 Speed Optimizer or Magento 2 Speed Optimize (also known as [Google page speed optimizer Magento 2](https://magepow.com/magento2-speed-optimizer.html)) of Magepow will help speed up your website.

Overall, there are many ways to speed up your website. However, in some cases if your hosting is too weak and can hardly meet the data source on your website. We recommend upgrading your hosting plan. It is one of the easiest and fastest ways to improve website speed in such cases. Currently we offer several hosting packages with configuration settings to get high performance for your store.

#### Magento Cloud | Magepow

 [![magento cloud](https://github.com/magepow/magento2-SpeedOptimizer/blob/master/media/magento-hosting.jpg)](https://magepow.com/magento-cloud?ref=optimizespeed)

You can find out more [here](https://magepow.com/magento-cloud?ref=optimizespeed)

### Description
In fact, many research resources show that users often leave a website if it takes more than 3 seconds to load. Thus, it can be seen that a slow web speed will make you lose potential customers before they visit your store. (Read more [Why is website speed important](https://magepow.com/blog/post/why-is-site-speed-important/))

No doubt, the faster speed can bring to customers a great shopping experience instead of slow page loading. Understanding this, Google used speed as one of the factors to rank a website. If your [website speed](https://magepow.com/blog/things-to-know-about-website-speed/) is fast, your chances of getting to the top will be higher, reach more potential customers, and your ability to sell goods will be higher. 

To test your web speed you can use [Google PageSpeed Insights](https://developers.google.com/speed/pagespeed/insights/). This is a free tool of Google that allows you to [test the website speed](https://magepow.com/blog/website-speed-test-tools/). If the result is below 80 points, we recommend that you explore ways to make your website perform better. 

Some other tools to measure website speed such as: [Lighthouse](https://magepow.com/blog/google-lighthouse-pagespeed-test-tool/), [GTmetrix](https://magepow.com/blog/website-speed-test-gtmetrix/)...  

Let's find out [why website loading speed very slow](https://magepow.com/blog/website-loading-speed-very-slow/) and them in a number of ways such as: move your website to a better host, using the CDN, minimize HTTP requests, files, optimize CSS, lazy loading, [reduce image sizes to speed up website](https://magepow.com/blog/how-to-speed-up-image-loading-on-website/), use external hosting platforms, reduce the number of plugins, reduce redirects, enable browser caching, set up G-Zip encryption to compress data, [monitor mobile page speed](https://magepow.com/blog/how-to-speed-up-website-for-mobile/)... (Detailed information about [how to speed up website](https://magepow.com/blog/how-to-speed-up-website/))

Speed Optimizer for Magento 2 is the extension that can help page speed optimization and performance optimization by using simple and quick configurations. No coding needed, the store owners also can enable, manage, configure in Admin Panel. For example, in the Admin Panel, you can easy to apply LazyLoad, minify HTML, defer JavaScripts... to improve your website speed. Therefore, Magento 2 Speed Optimizer extension will help you save much time and cost.

[![Latest Stable Version](https://poser.pugx.org/magepow/speedoptimizer/v/stable)](https://packagist.org/packages/magepow/speedoptimizer)
[![Total Downloads](https://poser.pugx.org/magepow/speedoptimizer/downloads)](https://packagist.org/packages/magepow/speedoptimizer)
[![Daily Downloads](https://poser.pugx.org/magepow/speedoptimizer/d/daily)](https://packagist.org/packages/magepow/speedoptimizer)

### Highlight Features
#### 1. Easy To Enable/Disable 
- Disable and Enable the module whenever you want in Admin Panel.
 
#### 2. Preloading Body
- Allow applying Preloading Body and upload Loading Body placeholder
- Allow applying Preloading Images and upload Image placeholder
 
#### 3. Lazy Load
- Ability to exclude Images that you don't want to apply lazy load and preloading based on Image classes (use comma to separate).
- Support for placeholder images to keep the layout of the website not broken when the site isn't loaded completely.
- Allow setting the place that you want to apply to lazyload from that to bottom by busing ID or class of the block.
- This is ideal for those who don't want to apply lazy load to the page-top such as the header or top banner slider.
 
#### 4. Minify/Defer Files
- Support minify javascript inline
- Defer javascript: move Javascript to page bottom. A script that will not run until after the page has loaded (This is abandon magento avaiable feature in Admin Panel > Stores > Configuration > Advanced > Developer > Javascript Settings > Move JS code to the bottom of the page => Choose "Yes" )
- Support minify CSS inline
 
#### 5. Easy To Customize
- Scripts and Style Sheets: This field is for who want to customize the lazy load, use particular scripts or style.

**Pro version with outstanding features**

| Features  | Free Version  | Pro Version |
| :------------ |:---------------:| :-----:|
|Preloading Body|:white_check_mark:|:white_check_mark:|
|Change the preloading body icon|:white_check_mark:|:white_check_mark:|
|Preloading Images|:white_check_mark:|:white_check_mark:|
|Change the preloading images icon|:white_check_mark:|:white_check_mark:|
|Lazy Load |:white_check_mark:|:white_check_mark:|
|Exclude images that loaded, not lazy or do not want to be preloaded|:white_check_mark:|:white_check_mark:|
|Placeholder help keep layout original while loading|:white_check_mark:|:white_check_mark:|
|Set the position where you want to apply the lazy load from that to bottom|:white_check_mark:|:white_check_mark:|
|Exclude HTML in desktop version|:white_check_mark:|:white_check_mark:|
|Exclude HTML in mobile version|:white_check_mark:|:white_check_mark:|
|Minify Html|:white_check_mark:|:white_check_mark:|
|Minify inline Javascript|:white_check_mark:|:white_check_mark:|
|Customize the lazy load, use particular scripts or style|:white_check_mark:|:white_check_mark:|
|Do not load images until mouse movement|X|:white_check_mark:|
|Enabled mode no-js support optimize scores Gtmetrix or Google pagespeed|X|:white_check_mark:|
|The unladen image will appear as a frame with the background|X|:white_check_mark:|
|Customize background color|X|:white_check_mark:|
|Customize background opacity|X|:white_check_mark:|

Download the latest version at [Magento 2 Speed Optimization Extension](https://magepow.com/magento2-speed-optimizer.html)

### Result After using Magento 2 Speed Optimizer Extension

#### Speed Test On Gtmetrix.Com

 ![speedoptimizer-img](https://github.com/magepow/magento2-SpeedOptimizer/blob/master/media/speed_gtmetrix.png)

#### Speed Test On Google PageSpeed Insights

 ![speedoptimizer-img](https://github.com/magepow/magento2-SpeedOptimizer/blob/master/media/speed_google.jpg)
 
### Magento 2 Speed Optimization Service of Magepow
 [![ Magento Speed Optimization Service](https://github.com/magepow/magento2-speedoptimizer/blob/master/media/Magento_Speed_Optimization_Pro.png)](https://magepow.com/magento-speed-optimization-service.html)
### How to install Magento 2 Speed Optimizer
#### ✓ Install Magepow Speed Optimizer via composer (recommend)
Run the following command in Magento 2 root folder:

```
composer require magepow/speedoptimizer
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy -f
```

#### ✓ Install Package from ```copy paste``` package


### Page Speed Optimization FAQs

#### Q: I got error javascript after enabled module
A: The error can cause with SyntaxError: missing ; before statement. When module speedoptimizer minify js will cause error
	You can read more error here [SyntaxError: missing ; before statement.](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Missing_semicolon_before_statement)
Solution 1 (Recommend): Fixed the all missing ; before statement you can use 'use strict'; in code to find js to find and fixed error missing ; before statement.
	You can read more how to use 'use strict'; here [use strict](https://www.w3schools.com/js/js_strict.asp) or [Strict mode](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode) 

Solution 2: Go to Admin Panel > Stores > Configuration > Magepow > Speed Optimizer > Minify inline Javascript => Choose "No"

### Detail User Guide
* [User Guide Magento 2 Speed Optimize Extension](https://docs.alothemes.com/m2/extension/speedoptimizer/)

### Donation

If this project help you reduce time to develop, you can give me a cup of coffee :) 

[![paypal](https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif)](https://www.paypal.com/paypalme/alopay)


**[Our Magento 2 Extensions](https://magepow.com/magento-2-extensions.html)**

* [Magento 2 Recent Sales Notification](https://magepow.com/magento-2-recent-order-notification.html)

* [Magento 2 Categories Extension](https://magepow.com/magento-categories-extension.html)

* [Magento 2 Sticky Cart](https://magepow.com/magento-sticky-cart.html)

* [Magento 2 Ajax Contact](https://magepow.com/magento-ajax-contact-form.html)

* [Magento 2 Lazy Load](https://magepow.com/magento-lazy-load.html)

* [Magento 2 Mutil Translate](https://magepow.com/magento-multi-translate.html)

* [Magento 2 Instagram Integration](https://magepow.com/magento-2-instagram.html)

* [Magento 2 Lookbook Pin Products](https://magepow.com/lookbook-pin-products.html)

* [Magento 2 Product Slider](https://magepow.com/magento-product-slider.html)

* [Magento 2 Product Banner](https://magepow.com/magento-2-banner-slider.html)

**[Our Magento 2 services](https://magepow.com/magento-services.html)**

* [PSD to Magento 2 Theme Conversion](https://alothemes.com/psd-to-magento-theme-conversion.html)

* [Magento 2 Speed Optimization Service](https://magepow.com/magento-speed-optimization-service.html)

* [Magento 2 Security Patch Installation](https://magepow.com/magento-security-patch-installation.html)

* [Magento 2 Website Maintenance Service](https://magepow.com/website-maintenance-service.html)

* [Magento 2 Professional Installation Service](https://magepow.com/professional-installation-service.html)

* [Magento 2 Upgrade Service](https://magepow.com/magento-upgrade-service.html)

* [Magento 2 Customization Service](https://magepow.com/customization-service.html)

* [Hire Magento 2 Developer](https://magepow.com/hire-magento-developer.html)

**[Our Magento 2 Themes](https://alothemes.com/)**

* [Expert Multipurpose Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/expert-premium-responsive-magento-2-and-1-support-rtl-magento-2-/21667789)

* [Gecko Premium Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/gecko-responsive-magento-2-theme-rtl-supported/24677410)

* [Milano Fashion Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/milano-fashion-responsive-magento-1-2-theme/12141971)

* [Electro 2 Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/electro2-premium-responsive-magento-2-rtl-supported/26875864)

* [Electro Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/electro-responsive-magento-1-2-theme/17042067)

* [Pizzaro Food responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/pizzaro-food-responsive-magento-1-2-theme/19438157)

* [Biolife organic responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/biolife-organic-food-magento-2-theme-rtl-supported/25712510)

* [Market responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/market-responsive-magento-2-theme/22997928)

* [Kuteshop responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/kuteshop-multipurpose-responsive-magento-1-2-theme/12985435)

* [Bencher - Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/bencher-responsive-magento-1-2-theme/15787772)

* [Supermarket Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/supermarket-responsive-magento-1-2-theme/18447995)

**[Our Shopify Themes](https://themeforest.net/user/alotheme)**

* [Dukamarket - Multipurpose Shopify Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/dukamarket-multipurpose-shopify-theme/36158349)

* [Ohey - Multipurpose Shopify Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/ohey-multipurpose-shopify-theme/34624195)

* [Flexon - Multipurpose Shopify Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/flexon-multipurpose-shopify-theme/33461048)

**[Our Shopify App](https://apps.shopify.com/partners/maggicart)**

* [Magepow Infinite Scroll](https://apps.shopify.com/magepow-infinite-scroll)

* [Magepow Promotionbar](https://apps.shopify.com/magepow-promotionbar)

* [Magepow Size Chart](https://apps.shopify.com/magepow-size-chart)

**[Our WordPress Theme](https://themeforest.net/user/alotheme/portfolio)**

* [SadesMarket - Multipurpose WordPress Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/sadesmarket-multipurpose-wordpress-theme/35369933)
