## Magento 2 Ajax Cart Extension

**[Magento 2 Ajax add to cart extension by Magepow](https://magepow.com/magepow/magento-2-ajax-add-to-cart.html)** is a module that allows customers to add products to their shopping cart on the homepage, category page, product page, CMS, or any page on the website through the Ajax pop-up window without having to redirect to another page. Completely reduce redirect wait times and improve the shopping experience.

### Description
Currently, online shopping is becoming more and more popular and has become a favorite form of shopping because of its speed and simplicity.

When shopping online, customers don't want to be redirected to another page when they add items to their cart. They will get annoyed and impatient if they have to wait too long to load new pages like Product Detail Pages or Cart View Pages.

Ajax (short for Asynchronous JavaScript and XML) is a technique that allows users to change any part of a web page without reloading the page.

During the study of customer behavior on e-commerce websites, we found that integrating Ajax into the “Add to Cart” button can reduce page navigation time, thereby optimizing the buying process of customers. So we created Magento 2 Ajax Cart Extension.

With Magento 2 Ajax Cart Extension, Ajax technology has been added to the cart. Instead of navigating to the checkout page, an Ajax popup will appear with information about the image, name, product price, number of products in cart, total order payment, etc.

![Magento 2 Ajax Cart Extension](https://github.com/magepow/magento-2-ajax-cart/blob/master/media/magento-2-ajax-cart-1.gif)

Customers can view product details quickly, add products to cart without leaving the current page, can continue shopping or redirect to the checkout page, enhancing the experience customer shopping.

With simple configuration, easy customization, use Magento 2 Ajax Cart Extension's built-in features to professionalize your website.

### Highlight Features 
**1. Ajax add to cart**

Ajax add to cart helps customers to order favorite items quickly and conveniently without being redirected to another page.
Customers will see product details through a popup window, and select product attributes such as color, size, quantity and add that product to cart right through this popup.
![Magento 2 Ajax Cart Extension](https://github.com/magepow/magento-2-ajax-cart/blob/master/media/magento-2-ajax-cart-2.gif)

**2. 2 amazing popup templates**

2 amazing popup templates suitable for any kind of store: Mini Popup and Middle to cart sidebar Popup.

Mini Popup

![Magento 2 Ajax Cart Extension](https://github.com/magepow/magento-2-ajax-cart/blob/master/media/magento-2-ajax-cart-3.png)

Middle to cart sidebar Popup

![Magento 2 Ajax Cart Extension](https://github.com/magepow/magento-2-ajax-cart/blob/master/media/magento-2-ajax-cart-4.png)

**3. Easy Customization**

Store admin can easily customize the appearance of the pop-up to match the store theme.
- Customize the color of text on buttons
- Customize the text of “Continue” button, 'Continue' Button Color, 'Continue' Button Color on Hover
- Customize the Text of 'View Cart' Button, 'View Cart' Button Color, 'View Cart' Button Color on Hover.
- Customize Text of 'Free Shipping Message', Text of 'Congratulation Message' 5: Quick View Popup Setting
- Choose to show/not show the 'Go to Product' link
- Choose to show/not show Additional Data
- …

**4. Responsive**

Magento 2 Ajax Cart Extension is responsive with all browsers and devices. In addition, you can also set responsiveness in different sizes.

### Pro version with outstanding features

| Features  | Free Version  | Pro Version |
| :------------ |:---------------:| :-----:|
|Ajax add to cart|:white_check_mark:|:white_check_mark:|
|2 amazing popup templates|X|:white_check_mark:|
|Mini Popup|:white_check_mark:|:white_check_mark:|
|- Show Product Image|:white_check_mark:|:white_check_mark:|
|- Image Width|:white_check_mark:|:white_check_mark:|
|- Image Height|:white_check_mark:|:white_check_mark:|
|- Show Product Price|:white_check_mark:|:white_check_mark:|
|- Show 'Continue' Button|:white_check_mark:|:white_check_mark:|
|- Countdown time for Button|:white_check_mark:|:white_check_mark:|
|- Countdown|:white_check_mark:|:white_check_mark:|
|- Show Cart Quantity and Cart Subtotal|:white_check_mark:|:white_check_mark:|
|- Show 'Go to Checkout' link|:white_check_mark:|:white_check_mark:|
|- Show Suggested Products|:white_check_mark:|:white_check_mark:|
|- Title of Suggested Products Block|X|:white_check_mark:|
|- Choose Suggested Products|X|:white_check_mark:|
|- Number of Suggested Products|X|:white_check_mark:|
|Middle to cart sidebar Popup|X|:white_check_mark:|
|Success Popup Design|:white_check_mark:|:white_check_mark:|
|Suggested Products Setting|X|:white_check_mark:|
|Responsive|:white_check_mark:|:white_check_mark:|
|Setting responsive|X|:white_check_mark:|

Download the latest version of [Magento 2 Ajax Cart](https://magepow.com/magento-2-ajax-add-to-cart.html) at [Magepow.com](https://magepow.com/)

[![Latest Stable Version](https://poser.pugx.org/magepow/ajaxcart/v/stable)](https://packagist.org/packages/magepow/ajaxcart)
[![Total Downloads](https://poser.pugx.org/magepow/ajaxcart/downloads)](https://packagist.org/packages/magepow/ajaxcart)
[![Daily Downloads](https://poser.pugx.org/magepow/ajaxcart/d/daily)](https://packagist.org/packages/magepow/ajaxcart)
 
### Magento 2 Ajax cart extension user guide
- [Video tutorial](https://www.youtube.com/watch?v=KVg1uew0hfU&t=15s)

- [Document](http://docs.magepow.com/ajaxcart/)

### How to install Magento 2 Ajax cart Free
**Install Ajax add to cart for Magento 2 via composer (recommend)**

Run the following command in Magento 2 root folder:

```
composer require magepow/ajaxcart
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy -f
```

### Donation

If this project help you reduce time to develop, you can give me a cup of coffee :) 

[![paypal](https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif)](https://www.paypal.com/paypalme/alopay)


**[Our Magento 2 Extensions](https://magepow.com/magento-2-extensions.html)**

* [Magento 2 Recent Sales Notification](https://magepow.com/magento-2-recent-sales-notification.html)

* [Magento 2 Categories Extension](https://magepow.com/magento-categories-extension.html)

* [Magento 2 Sticky Cart](https://magepow.com/magento-sticky-cart.html)

* [Magento 2 Ajax Contact](https://magepow.com/magento-ajax-contact-form.html)

* [Magento 2 Lazy Load](https://magepow.com/magento-lazy-load.html)

* [Magento 2 Mutil Translate](https://magepow.com/magento-multi-translate.html)

* [Magento 2 Instagram Integration](https://magepow.com/magento-2-instagram.html)

* [Magento 2 Lookbook Pin Products](https://magepow.com/lookbook-pin-products.html)

* [Magento 2 Product Slider](https://magepow.com/magento-product-slider.html)

* [Magento 2 Product Banner](https://magepow.com/magento-banner-slider.html)

**[Our Magento 2 services](https://magepow.com/magento-services.html)**

* [PSD to Magento 2 Theme Conversion](https://magepow.com/psd-to-magento-theme-conversion.html)

* [Magento 2 Speed Optimization Service](https://magepow.com/magento-speed-optimization-service.html)

* [Magento 2 Security Patch Installation](https://magepow.com/magento-security-patch-installation.html)

* [Magento 2 Website Maintenance Service](https://magepow.com/website-maintenance-service.html)

* [Magento 2 Professional Installation Service](https://magepow.com/professional-installation-service.html)

* [Magento 2 Upgrade Service](https://magepow.com/magento-upgrade-service.html)

* [Magento 2 Customization Service](https://magepow.com/customization-service.html)

* [Hire Magento 2 Developer](https://magepow.com/hire-magento-developer.html)

**[Our Magento 2 Themes](https://alothemes.com/)**

* [Expert Multipurpose Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/expert-premium-responsive-magento-2-and-1-support-rtl-magento-2-/21667789)

* [Gecko Premium Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/gecko-responsive-magento-2-theme-rtl-supported/24677410)

* [Milano Fashion Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/milano-fashion-responsive-magento-1-2-theme/12141971)

* [Electro 2 Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/electro2-premium-responsive-magento-2-rtl-supported/26875864)

* [Electro Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/electro-responsive-magento-1-2-theme/17042067)

* [Pizzaro Food responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/pizzaro-food-responsive-magento-1-2-theme/19438157)

* [Biolife organic responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/biolife-organic-food-magento-2-theme-rtl-supported/25712510)

* [Market responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/market-responsive-magento-2-theme/22997928)

* [Kuteshop responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/kuteshop-multipurpose-responsive-magento-1-2-theme/12985435)

* [Bencher - Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/bencher-responsive-magento-1-2-theme/15787772)

* [Supermarket Responsive Magento 2 Theme](https://1.envato.market/c/1314680/275988/4415?u=https://themeforest.net/item/supermarket-responsive-magento-1-2-theme/18447995)
