# Magento 2 Command Line Extension by Magefan

[![Total Downloads](https://poser.pugx.org/magefan/module-cli/downloads)](https://packagist.org/packages/magefan/module-cli)
[![Latest Stable Version](https://poser.pugx.org/magefan/module-cli/v/stable)](https://packagist.org/packages/magefan/module-cli)

<a href="https://savelife.in.ua/en/donate-en/#donate-army-card-monthly"><img width="830" height="208" src="https://cm.magefan.com/blog/support-ukraine.png"></a>

<img width="150" height="100" src="https://magefan.com/media/wysiwyg/made_in_ukraine.jpg">

<img align="right" width="120" height="120" src="https://cm.magefan.com/catalog/product/cache/28b407cef1668fd0bdd6f36db3e8e2f0/i/c/icon-cli-extension_1.jpg">

[Magento 2 CLI module](https://magefan.com/magento2-cli-extension) allows you to run CLI commands from admin panel (System > Tools > Command Line) using exec php function. You can restrict access to this interface using Magento 2 Access Control List. We recommend to use it ONLY on dev environments as it is not securely to run exec.


<a href="https://magefan.com/magento2-cli-extension"><img width="190" height="70" src="https://cm.magefan.com/wysiwyg/products/download-magefan-extensions.png"></a><a href="https://magefan.com/magento2-cli-extension#live-demo"><img width="190" height="70" src="https://cm.magefan.com/wysiwyg/products/magefan-live-demo.png"></a>

![alt text](https://magefan.com/media/wysiwyg/magento2-cli.png)

## Requirements
  * Magento Community Edition 2.1.x-2.4.x or Magento Enterprise Edition 2.1.x-2.4.x
  * Exec function needs to be enabled in PHP settings.

## Installation Method 1 - Installing via composer
  * Open command line
  * Using command "cd" navigate to your magento2 root directory
  * Run command: composer require magefan/module-cli

## Installation Method 2 - Installing using archive
  * Download [ZIP Archive](https://magefan.com/magento2-cli-extension)
  * Extract files
  * In your Magento 2 root directory create folder app/code/Magefan/Cli
  * Copy files and folders from archive to that folder
  * In command line, using "cd", navigate to your Magento 2 root directory
  * Run commands:
```
php bin/magento setup:upgrade
php bin/magento setup:di:compile
php bin/magento setup:static-content:deploy
```

## Support
If you have any issues, please [contact us](mailto:support@magefan.com)
then if you still need help, open a bug report in GitHub's
[issue tracker](https://github.com/magefan/module-cli/issues).

Please do not use Magento Marketplace Reviews or (especially) the Q&A for support.
There isn't a way for us to reply to reviews and the Q&A moderation is very slow.

## Need More Features?
Please contact us to get a quote
https://magefan.com/contact

## License
The code is licensed under [EULA](https://magefan.com/end-user-license-agreement).

## [Magento 2 Extensions](https://magefan.com/magento-2-extensions) by Magefan

### [Magento 2 Admin Panel Extensions](https://magefan.com/magento-2-extensions/admin-extensions)

  * [Magento 2 Edit Order Extension](https://magefan.com/magento-2-edit-order-extension)
  * [Magento 2 Better Order Grid Extension](https://magefan.com/magento-2-better-order-grid-extension)
  * [Magento 2 Extended Product Grid](https://magefan.com/magento-2-product-grid-inline-editor)
  * [Magento 2 Product Tabs Extension](https://magefan.com/magento-2/extensions/product-tabs)
  * [Magento 2 Facebook Pixel Extension](https://magefan.com/magento-2-facebook-pixel-extension)
  * [Magento 2 Email Attachments](https://magefan.com/magento-2-email-attachments)
  * [Magento 2 Admin View Extension](https://magefan.com/magento-2-admin-view-extension)
  * [Magento 2 Admin Email Notifications](https://magefan.com/magento-2-admin-email-notifications)
  * [Magento 2 Login As Customer Extension](https://magefan.com/login-as-customer-magento-2-extension)

### [Magento 2 Google Extensions](https://magefan.com/magento-2-extensions/google-extensions)

  * [Magento 2 Google Indexing API](https://magefan.com/magento-2-google-indexing-api)
  * [Magento 2 Google Analytics 4 Extension](https://magefan.com/magento-2-google-analytics-4)
  * [Magento 2 Google Tag Manager](https://magefan.com/magento-2-google-tag-manager)
  * [Magento 2 Google Shopping Feed](https://magefan.com/magento-2-google-shopping-feed-extension)
  * [Magento 2 Google Customer Reviews](https://magefan.com/magento-2-google-customer-reviews)

### [Magento 2 SEO Extensions](https://magefan.com/magento-2-extensions/magento-2-seo-extensions)

  * [Magento 2 SEO Extension](https://magefan.com/magento-2-seo-extension)
  * [Magento 2 Rich Snippets Extension](https://magefan.com/magento-2-rich-snippets)
  * [Magento 2 HTML Sitemap Extension](https://magefan.com/magento-2-html-sitemap-extension)
  * [Magento 2 XML Sitemap Extension](https://magefan.com/magento-2-xml-sitemap-extension)
  * [Magento 2 Twitter Cards Extension](https://magefan.com/magento-2-twitter-cards-extension)
  * [Magento 2 Facebook Open Graph Extension](https://magefan.com/magento-2-open-graph-extension-og-tags)

### [Magento 2 Blog Extensions](https://magefan.com/magento-2-extensions/blog-extensions)

  * [Magento 2 Blog Extension](https://magefan.com/magento2-blog-extension)
  * [Magento 2 Blog Plus Extension](https://magefan.com/magento2-blog-extension/pricing)
  * [Magento 2 Blog Extra Extension](https://magefan.com/magento2-blog-extension/pricing)
  * [Magento 2 Multi Blog Extension](https://magefan.com/magento-2-multi-blog-extension)
  * [Magento 2 Product Widget Advanced Extension](https://magefan.com/magento-2-product-widget)

### [Magento 2 Marketing Automation Extensions](https://magefan.com/magento-2-extensions/magento-marketing-automation)

* [Magento 2 Dynamic Categories](https://magefan.com/magento-2-dynamic-categories)
* [Magento 2 CMS Display Rules Extension](https://magefan.com/magento-2-cms-display-rules-extension)
* [Magento 2 Automatic Related Products](https://magefan.com/magento-2-automatic-related-products)
* [Magento 2 Price History](https://magefan.com/magento-2-price-history)
* [Magento 2 Mautic Integration Extension](https://magefan.com/magento-2-mautic-extension)
* [Magento 2 YouTube Widget Extension](https://magefan.com/magento2-youtube-extension)
    
 
### [Magento 2 Cart Extensions](https://magefan.com/magento-2-extensions/cart-extensions)

  * [Better Magento 2 Checkout Extension](https://magefan.com/better-magento-2-checkout-extension)
  * [Magento 2 Coupon Code Link](https://magefan.com/magento-2-coupon-code-link)
  * [Magento 2 Convert Guest to Customer Extension](https://magefan.com/magento2-convert-guest-to-customer)

### [Magento 2 Speed Optimization Extensions](https://magefan.com/magento-2-extensions/speed-optimization-extensions)

  * [Magento 2 Lazy Load Extension](https://magefan.com/magento-2-image-lazy-load-extension)
  * [Magento 2 WebP Optimized Images Extension](https://magefan.com/magento-2-webp-optimized-images)
  * [Magento 2 Rocket JavaScript Extension](https://magefan.com/rocket-javascript-deferred-javascript)

### [Magento 2 Multi-Language Extensions](https://magefan.com/magento-2-extensions/multi-language-extensions)

  * [Magento 2 Hreflang Tags Extension](https://magefan.com/magento2-alternate-hreflang-extension)
  * [Magento 2 Auto Currency Switcher Extension](https://magefan.com/magento-2-currency-switcher-auto-currency-by-country)
  * [Magento 2 Auto Language Switcher Extension](https://magefan.com/magento-2-auto-language-switcher)
  * [Magento 2 GeoIP Switcher Extension](https://magefan.com/magento-2-geoip-switcher-extension)
  * [Magento 2 Translation Extension](https://magefan.com/magento-2-translation-extension)

### Developers Tools

  * [Magento 2 Zero Downtime Deployment](https://magefan.com/blog/magento-2-zero-downtime-deployment)
  * [Magento 2 Cron Schedule](https://magefan.com/magento-2-cron-schedule)
  * [Magento 2 Conflict Detector Extension](https://magefan.com/magento2-conflict-detector)

  ### Magento 2 Point of Sale

  * [Magento 2 POS System](https://magefan.com/magento-pos-system)

  ### Magento 2 Theme

  * [Optimized Magento 2 Theme](https://magefan.com/optimized-magento-2-theme)
   
  ### Shopify Apps

  * [Shopify Login As Customer](https://apps.shopify.com/login-as-customer)
  * [Shopify Blog](https://apps.shopify.com/magefan-blog)
  
  ### Shopware Extensions
  
  * [Shopware WebP Extension](https://magefan.com/shopware/extensions/webp)
  * [Shopware Blog Extension](https://magefan.com/shopware/extensions/blog)
