<meta name="title" content="Magento 2 Blog Extension | GitHub"/>

# Magento 2 Blog Extension

<img align="right" width="120" height="120" src="https://cm.magefan.com/mf_webp/jpg/media/catalog/product/cache/28b407cef1668fd0bdd6f36db3e8e2f0/i/c/icon-blog-ext_1.webp">

Magento 2 Blog extension is a solution that allows you to manage your store and blog in Magento from one place without having to rely on some third-party platforms. This blog extension for Magento 2 is a multifunctional marketing tool that will not only help you to create blog posts in Magento, but drive more traffic, boost SEO, and improve your Google rating. Our [Magento 2 Blog Extension](https://magefan.com/magento2-blog-extension) is one of the best Magento 2 extensions with more than 1 250 000 downloads.

[![Total Downloads](https://poser.pugx.org/magefan/module-blog/downloads)](https://packagist.org/packages/magefan/module-blog)
[![Latest Stable Version](https://poser.pugx.org/magefan/module-blog/v/stable)](https://packagist.org/packages/magefan/module-blog)

<a href="https://savelife.in.ua/en/donate-en/#donate-army-card-monthly"><img width="830" height="208" src="https://cm.magefan.com/blog/support-ukraine.png"></a>

<img width="150" height="100" src="https://magefan.com/media/wysiwyg/made_in_ukraine.jpg">

<a href="https://magefan.com/magento2-blog-extension"><img width="190" height="70" src="https://cm.magefan.com/wysiwyg/products/download-magefan-extensions.png"></a><a href="https://magefan.com/magento2-blog-extension#live-demo"><img width="190" height="70" src="https://cm.magefan.com/wysiwyg/products/magefan-live-demo.png"></a>

## Requirements
  * Magento Community 2.3.0-2.4.x (CE, EE, ECE, B2B)
  * [Magefan Community Extension](https://github.com/magefan/module-community) >= v2.0.14. Please install this extension first if you use installation via FTP.
  * **Note** that the extension is free only for the Magento Community (Open Source) Edition. For Magento EE, ECE, and B2B you need to purchase the license for [Blog Base or go with Blog Plus, Blog Extra](https://magefan.com/magento2-blog-extension/pricing).
  * **ATTENTION!** Latest available version for Magento 2.1.x is Blog v2.9.0.1

## Editions & Pricing
  
<a href="https://magefan.com/magento2-blog-extension/pricing">
          <img
            src="https://cm.magefan.com/wysiwyg/products/blog-pricing.png"
            alt="Magento 2 Blog Editions & Pricing" />
        </a>      
        
## Main Features
  * **NEW!** Blog GraphQL
  * Unlimited blog posts, multi-level categories, and tags
  * Multilanguage and Multiple Websites Support
  * Facebook, Disqus, Google+, and Magefan Magento Comments
  * Related products and posts
  * Post media gallery & video
  * Next & Previous Post
  * Posts search
  * Posts Lazy Load
  * Author information and posts by the author
  * Recent Posts, Featured Posts, Archive, Categories, Search From, Tags Cloud sidebar widgets
  * Import Posts and Categories from WordPress and AW Blog extension for M1
  * Posts and Categories duplication
  * Blog RSS Feed
  * REST API  
  * 100% Open Source
  * Compatible with [Porto Theme](https://themeforest.net/item/porto-ultimate-responsive-magento-theme/9725864?ref=magefan) for Magento 2
  * Accelerated Mobile Pages (AMP) Project support. To enable AMP view on blog pages [Magento Amp Extension](http://magefan.com/accelerated-mobile-pages/) by Plumrocket is required.
  * Blog Sitemap XML
  * SEO-friendly URLs
  * Structured Data
  * Open Graph (OG) meta tags
  * Canonical URL  
  * [Much More](https://magefan.com/magento2-blog-extension/pricing)
  
## Benefits
**More traffic to your website**

Targeting the top-ranked keywords and writing compelling content you will ensure more people will find your Magento 2 blog and consequently more people will come to your website.

**Improved your Magento 2 website SEO**

According to the previous point, the more traffic your Magento 2 blog brings, the more relevant your website appears to Google. So it will put your Magento 2 store pages higher and show them more often correspondingly.

**Improved customer engagement**

The system of Magento 2 blog posts, categories, tags, internal links, and sidebar navigation will create a great customer experience and will encourage them to come back and spend more time on your Magento 2 website since it is easy to navigate and pleasant to spend time on.

**Magento 2 store product promotion**

Magento 2 Blog extension allows you to add related products to your blog posts as well as show the related blog posts in the product descriptions. You can promote your Magento 2 store products in your blog and vice versa. This connection will allow people coming to your website to surf through it continuously.

**Social media promotion**

The best way to make your blog recognized and get even more traffic is to promote it on social media. Magento 2 Blog module allows you to automatically publish your blog posts to your Facebook page so that you don’t need to do it manually and schedule the publication.

**Worldwide recognition**

Managing a multi-language store would be great since you could reach a wider audience and appeal to more customers. Fortunately, the Magento 2 Blog extension supports multiple languages and websites. Thus, you can create stunning content for people from different countries and benefit from improved traffic and worldwide recognition.

## Features

### Unlimited blog posts, multi-level categories, and tags

By creating interesting and engaging blog posts, adding them to multiple blog categories, and marking them with tags you create a Magento 2 blog people would want to visit and read because of the simplicity of use and navigation.

<p align="center">
  <img width="860" height="428" src="https://cm.magefan.com/mf_webp/png/media/blog/magento-2-blog-posts-categories-tags.webp">
</p>

### Multilanguage and Multiple Websites Support

Managing a blog for a Magento 2 store in one language is good for traffic and SEO, but managing a blog in multiple languages is even better. Magento 2 Blog extension supports multiple languages so that you can reach the worldwide audience providing them with the content in their local language. This blog module for Magento 2 also supports multiple websites so you can create content for different Magento 2 websites and conveniently manage them from one place.

### Facebook, Disqus, and Magefan Magento Comments

The first step to establishing a good relationship with your customers and getting honest feedback about your blog are comments. Magento 2 Blog extension supports 3 types of comments: Magefan, Facebook, and Disqus. You can study the tendencies and things your blog readers like the most and use it for further development of your Magento 2 Blog.

### Related products and posts

Related products and posts are one of the best ways to make people stay on your website longer. Showing really relevant products and blog posts you encourage readers to have a look at your Magento 2 store products and read some other interesting things on your blog. 

<p align="center">
  <img width="860" height="428" src="https://cm.magefan.com/mf_webp/png/media/wysiwyg/magento-2-blog-related-products.webp">
</p>

### Blog Sitemap XML

Google is analyzing a lot of things on your Magento 2 website in order to choose which place to put it on. Configuring Magento 2 blog sitemap you choose what pages to allow Google to access and analyze to improve your blog positions.

### SEO-friendly URLs

Nowadays, you need to pay huge attention to SEO in order to be found. Magento 2 Blog extension uses only the best SEO practices and allows you to create the SEO- friendly URLs for your blog so that people can easily find your posts on Google.

<p align="center">
  <img width="860" height="428" src="https://cm.magefan.com/mf_webp/png/media/wysiwyg/seo-friendly-blog-url.webp">
</p>

### Open Graph (OG) meta tags

Social media are the very first place you should start promoting your Magento 2 store and blog on. In case you want to make your posts clickable and more attractive you have to configure the Facebook Open Graph tags for them.

### Author information and posts by the author

Create, edit and delete authors on your Magento 2 blog and sort your blog posts by the author to let people know where is the information coming from and who is providing it. 

### Recent Posts, Featured Posts, Archive, Categories, Search From, Tags Cloud sidebar widgets

Magento 2 Blog extension allows you to improve your blog visitors’ experience with the help of the blog sidebar. There are gathered all relevant things people can look for from Category Tree and Popular Posts to Achieve and RSS Feed. Magento 2 Sidebar makes your blog navigation easier and more effective. 

<p align="center">
  <img width="860" height="428" src="https://cm.magefan.com/mf_webp/png/media/wysiwyg/magento-blog-sidebar.webp">
</p>

### Post media gallery & video

Adding pictures and videos to your blog posts make them more diverse and interesting since no one likes reading one-piece texts. Magento 2 blog extension allows you to add plenty of pictures to the blog media gallery to provide the blog readers with more relevant images. 

### Next & Previous Post

Internal linking is considered as important as the external one. One of the ways to add them is next and previous post links that encourage your Magento 2 blog readers to surf through your blog continuously and stay longer engaged with your content.

### Posts search

Allow your blog readers to find an article they are interested in faster with the Magento 2 blog search form.

### Posts Lazy Load

Enable lazy loading on your Magento 2 blog in order for blog posts on your blog index page to load just when scrolling down. That way you’ll ensure the website loading speed is fast and your blog readers don’t have to wait to get to the content of their interest.

### Import Posts and Categories form WordPress and AW Blog extension for M1

A lot of people are migrating to Magento 2 considering its growing popularity. So if you want to migrate your Wordpress or Aheadworks blog to Magento 2 you can easily do this since our Magento 2 Blog extension provides different kinds of blog imports.

### Posts and Categories duplication

Do you want to create the same category or blog posts with a slight content change or for translation? Magento 2 Blog extension has the feature of posts and categories duplication. So all you’ll need to do is to duplicate the blog post or blog category and then make changes to the title, description, or to the whole content if you like.

### 100% Open Code

Magento 2 is very flexible and customizable and so is our Magento 2 Blog extension. It is 100% Open Code so except for the big variety of features it is offering you can still make changes and add some improvements to make a blog for your Magento 2 store stand out.

### Compatible with [Porto Theme](https://themeforest.net/item/porto-ultimate-responsive-magento-theme/9725864?ref=magefan) for Magento 2

In case you were looking for a great theme for your Magento 2 store and wanted to start managing a blog you can have it all at once since our Magento 2 Blog extension is fully compatible with the Porto Theme for Magento 2.

### Blog GraphQL and Rest API Endpoints

In the mobile era, all major websites have started to create apps to make their customers’ shopping experience better. Magento 2 Blog extension has the GraphQL and Rest API endpoints that allow you to request or add data to your external software. Thus, if you decide to have your Magento 2 store and blog in an app you can easily do this.

## Demo

Try out our open demo and if you like our extension **please give us some star on Github ★**
<table>
  <tbody>
    <tr>
      <td align="center" valign="middle">
        Storefront Demo
      </td>
      <td align="center" valign="middle">
        Admin Panel Demo
      </td align="center" valign="middle">
    </tr>
    <tr>
      <td align="center" valign="middle">
        <a href="http://blog.demo.magefan.top/blog/">
          <img
            src="https://magefan.com/static/version1520969775/frontend/Magefan/new/en_US/images/product-tab-demo-1.jpg"
            alt="Magento 2 Blog Extension Storefront Demo"
            height="220"
          >
        </a>
      </td>
      <td align="center" valign="middle">
        <a href="http://blog.demo.magefan.top/admin/">
          <img
            src="https://magefan.com/static/version1520969775/frontend/Magefan/new/en_US/images/product-tab-demo-2.jpg"
            alt="Magento 2 Blog Extension Admin Panel Demo"
            height="220"
          >
        </a>
      </td>
    </tr>
    <tr>
      <td align="center" valign="middle">
        <a href="http://blog.demo.magefan.top/blog/">
          view
        </a>
      </td>
      <td align="center" valign="middle">
        <a href="http://blog.demo.magefan.top/admin/">
          view
        </a>
      </td>
    </tr>
  </tbody>
</table>

## Add-ons
  * [Blog GraphQL for Magneto 2.2.x by Magefan](https://github.com/magefan/module-blog-graph-ql)
  * [Blog Comments ReCaptcha by Magefan](https://github.com/magefan/module-blog-comments-recaptcha)
  * [Blog Integration with Plumrocker AMP Extension](https://github.com/magefan/module-blog-amp)
  * [ElasticSuite Blog search for Magento 2 by Comwrap](https://github.com/comwrap/Comwrap_ElasticsuiteBlog)


## Online Documentation
https://magefan.com/blog/magento-2-blog-extension-documentation


## Installation Instruction
https://magefan.com/blog/magento2-blog-extension-installation

## Magento 2 Blog Management
* [How to Create Blog Post?](https://magefan.com/blog/new-blog-post-in-magento-2)
* [How to Create Blog Category?](https://magefan.com/blog/new-blog-category-in-magento-2)
* [How to Create Blog Tag?](https://magefan.com/magento2-blog-extension/new-tag)
* [How to Create Blog Author?](https://magefan.com/magento-2-blog-extension/manage-author)
* [How to Configure Magento 2 Blog Sidebar?](https://magefan.com/magento2-blog-extension/sidebar)
* [How to Configure Blog Index Page?](https://magefan.com/magento-2-blog-extension/blog-index-page)
* [How to Configure Blog Comments?](https://magefan.com/magento2-blog-extension/comments-configuration)
* [How to Configure Blog Design?](https://magefan.com/magento2-blog-extension/design-configuration)
* [How to Configure Blog Permalink Setting?](https://magefan.com/blog/manage-magento-2-blog-permalink-settings)
* [How to Configure Magento 2 Blog Autopublication on Facebook?](https://magefan.com/magento2-blog-extension/facebook-auto-publishing)

## Support
If you have any issues, please [contact us](mailto:support@magefan.com)
then if you still need help, open a bug report in GitHub's
[issue tracker](https://github.com/magefan/module-blog/issues).

Please do not use Magento Marketplace Reviews or (especially) the Q&A for support.
There isn't a way for us to reply to reviews and the Q&A moderation is very slow.

## Need More Features?
Please contact us to get a quote
https://magefan.com/contact

## License
The code is licensed under [EULA](https://magefan.com/end-user-license-agreement).

## [Magento 2 Extensions](https://magefan.com/magento-2-extensions) by Magefan

### [Magento 2 Admin Panel Extensions](https://magefan.com/magento-2-extensions/admin-extensions)

  * [Magento 2 Admin Action Log](https://magefan.com/magento-2-admin-action-log)
  * [Magento 2 Edit Order Extension](https://magefan.com/magento-2-edit-order-extension)
  * [Magento 2 Better Order Grid Extension](https://magefan.com/magento-2-better-order-grid-extension)
  * [Magento 2 Extended Product Grid](https://magefan.com/magento-2-product-grid-inline-editor)
  * [Magento 2 Product Tabs Extension](https://magefan.com/magento-2/extensions/product-tabs)
  * [Magento 2 Facebook Pixel Extension](https://magefan.com/magento-2-facebook-pixel-extension)
  * [Magento 2 Email Attachments](https://magefan.com/magento-2-email-attachments)
  * [Magento 2 Admin View Extension](https://magefan.com/magento-2-admin-view-extension)
  * [Magento 2 Admin Email Notifications](https://magefan.com/magento-2-admin-email-notifications)
  * [Magento 2 Login As Customer Extension](https://magefan.com/login-as-customer-magento-2-extension)

### [Magento 2 Google Extensions](https://magefan.com/magento-2-extensions/google-extensions)

  * [Magento 2 Google Indexing API](https://magefan.com/magento-2-google-indexing-api)
  * [Magento 2 Google Analytics 4 Extension](https://magefan.com/magento-2-google-analytics-4)
  * [Magento 2 Google Tag Manager](https://magefan.com/magento-2-google-tag-manager)
  * [Magento 2 Google Shopping Feed](https://magefan.com/magento-2-google-shopping-feed-extension)
  * [Magento 2 Google Customer Reviews](https://magefan.com/magento-2-google-customer-reviews)

### [Magento 2 SEO Extensions](https://magefan.com/magento-2-extensions/magento-2-seo-extensions)

  * [Magento 2 SEO Extension](https://magefan.com/magento-2-seo-extension)
  * [Magento 2 Rich Snippets Extension](https://magefan.com/magento-2-rich-snippets)
  * [Magento 2 HTML Sitemap Extension](https://magefan.com/magento-2-html-sitemap-extension)
  * [Magento 2 XML Sitemap Extension](https://magefan.com/magento-2-xml-sitemap-extension)
  * [Magento 2 Twitter Cards Extension](https://magefan.com/magento-2-twitter-cards-extension)
  * [Magento 2 Facebook Open Graph Extension](https://magefan.com/magento-2-open-graph-extension-og-tags)

### [Magento 2 Blog Extensions](https://magefan.com/magento-2-extensions/blog-extensions)

  * [Magento 2 Multi Blog Extension](https://magefan.com/magento-2-multi-blog-extension)
  * [Magento 2 Product Widget Advanced Extension](https://magefan.com/magento-2-product-widget)

### [Magento 2 Marketing Automation Extensions](https://magefan.com/magento-2-extensions/magento-marketing-automation)

* [Magento 2 Product Labels](https://magefan.com/magento-2-product-labels)
* [Magento 2 Dynamic Categories](https://magefan.com/magento-2-dynamic-categories)
* [Magento 2 CMS Display Rules Extension](https://magefan.com/magento-2-cms-display-rules-extension)
* [Magento 2 Automatic Related Products](https://magefan.com/magento-2-automatic-related-products)
* [Magento 2 Price History](https://magefan.com/magento-2-price-history)
* [Magento 2 Mautic Integration Extension](https://magefan.com/magento-2-mautic-extension)
* [Magento 2 YouTube Widget Extension](https://magefan.com/magento2-youtube-extension)    
 
### [Magento 2 Cart Extensions](https://magefan.com/magento-2-extensions/cart-extensions)

  * [Better Magento 2 Checkout Extension](https://magefan.com/better-magento-2-checkout-extension)
  * [Magento 2 Coupon Code Link](https://magefan.com/magento-2-coupon-code-link)
  * [Magento 2 Convert Guest to Customer Extension](https://magefan.com/magento2-convert-guest-to-customer)

### [Magento 2 Speed Optimization Extensions](https://magefan.com/magento-2-extensions/speed-optimization-extensions)

  * [Magento 2 Lazy Load Extension](https://magefan.com/magento-2-image-lazy-load-extension)
  * [Magento 2 WebP Optimized Images Extension](https://magefan.com/magento-2-webp-optimized-images)
  * [Magento 2 Rocket JavaScript Extension](https://magefan.com/rocket-javascript-deferred-javascript)

### [Magento 2 Multi-Language Extensions](https://magefan.com/magento-2-extensions/multi-language-extensions)

  * [Magento 2 Hreflang Tags Extension](https://magefan.com/magento2-alternate-hreflang-extension)
  * [Magento 2 Auto Currency Switcher Extension](https://magefan.com/magento-2-currency-switcher-auto-currency-by-country)
  * [Magento 2 Auto Language Switcher Extension](https://magefan.com/magento-2-auto-language-switcher)
  * [Magento 2 GeoIP Switcher Extension](https://magefan.com/magento-2-geoip-switcher-extension)
  * [Magento 2 Translation Extension](https://magefan.com/magento-2-translation-extension)

### [Developers Tools](https://magefan.com/magento-2-extensions/developer-tools)

  * [Magento 2 Zero Downtime Deployment](https://magefan.com/blog/magento-2-zero-downtime-deployment)
  * [Magento 2 Cron Schedule](https://magefan.com/magento-2-cron-schedule)
  * [Magento 2 CLI Extension](https://magefan.com/magento2-cli-extension)
  * [Magento 2 Conflict Detector Extension](https://magefan.com/magento2-conflict-detector)

  ### Magento 2 Point of Sale

  * [Magento 2 POS System](https://magefan.com/magento-pos-system)

  ### Magento 2 Theme

  * [Optimized Magento 2 Theme](https://magefan.com/optimized-magento-2-theme)
   
  ### [Shopify Apps](https://magefan.com/shopify/apps)

  * [Shopify Login As Customer](https://apps.shopify.com/login-as-customer)
  * [Shopify Blog](https://apps.shopify.com/magefan-blog)
  * [Shopify Size Chart](https://magefan.com/shopify/apps/size-chart)
