<img align="right" style="float: right; height: 200px;" src="doc/images/search_autocomplete_logo.png">

# Search Autocomplete for Magento 2

Autocomplete search suggestions are common nowadays. When designed well, this functionality helps shoppers to construct their search queries and get to the searched products faster. Search Autocomplete was designed to make searching simple and intuitive. It delivers quick and precise results, thus helping customers get more effective queries.
Autocomplete functionality provides the intuitive search experience and instantly displays search suggestions based on the first-entered characters. This functionality helps customers move from the search box to the checkout as quickly as possible.

![](doc/images/search_autocomplete_popup.png)

## Features

**Instant search results in a customizable AJAX pop-up**  
**Suggested searches**   
**Smart search queries caching**  
**Adjustable search delay period**  
**The ability to specify the # of displayed search results**  
**Including product details (product image, SKU, price, reviews/ratings, etc.)**  
**"Add to Cart" button right in the search results**  

## How to install Search Suite Autocomplete for Magento 2

### Install via composer (recommend)
Run the following command in Magento 2 root folder:

```
composer require mageworx/module-searchsuiteautocomplete
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy
```

### Install ready-to-paste package (not recommend)

- Download the latest version [here](https://www.mageworx.com/magento-2-search-atocomplete-free.html)
-  [Installation guide](https://support.mageworx.com/manuals/autocomplete/#installation-by-copying-the-code)

## Changelog

[Changelog](changelog.md)

## Authors, contributors and maintainers

Author:
- [MageWorx](https://www.mageworx.com)

## Ideas, bugs, contributions, comments, feature suggestions?

Please get in touch with us via the [issue tracker on GitHub](https://github.com/mageworx/search-suite-autocomplete/issues)

## Compability

- PHP: 
  - 5.6.x
  - 7.0.x
  - 7.1.x
  - 7.2.x
- Magento CE: 
  - 2.0.x
  - 2.1.x
  - 2.2.x
  - 2.3.x
  - 2.4.x
- Magento EE:
  - 2.0.x
  - 2.1.x
  - 2.2.x
  - 2.3.x
  - 2.4.x
  
- Operating System: Linux

## Documentation

1. [Module Configuration](https://support.mageworx.com/manuals/autocomplete/#extension-configuration)

## License

[GPL v3](LICENSE.txt)

## Links

- [Search Suite Autocomplete on Magento Connect](https://marketplace.magento.com/mageworx-module-searchsuiteautocompletemeta.html)
- [Search Suite Autocomplete on MageWorx site](https://www.mageworx.com/magento-2-search-atocomplete-free.html)
